/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.network.BasePacketHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class SorterTagFilter
extends SorterFilter<SorterTagFilter>
implements ITagFilter<SorterTagFilter> {
    private String tagName;

    public SorterTagFilter() {
    }

    public SorterTagFilter(SorterTagFilter filter) {
        super(filter);
        this.tagName = filter.tagName;
    }

    @Override
    public Finder getFinder() {
        return Finder.tag(this.tagName);
    }

    @Override
    public CompoundTag write(CompoundTag nbtTags) {
        super.write(nbtTags);
        nbtTags.m_128359_("tagName", this.tagName);
        return nbtTags;
    }

    @Override
    public void read(CompoundTag nbtTags) {
        super.read(nbtTags);
        this.tagName = nbtTags.m_128461_("tagName");
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.m_130070_(this.tagName);
    }

    @Override
    public void read(FriendlyByteBuf dataStream) {
        super.read(dataStream);
        this.tagName = BasePacketHandler.readString(dataStream);
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        code = 31 * code + this.tagName.hashCode();
        return code;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) return false;
        if (!(o instanceof SorterTagFilter)) return false;
        SorterTagFilter filter = (SorterTagFilter)o;
        if (!filter.tagName.equals(this.tagName)) return false;
        return true;
    }

    @Override
    public SorterTagFilter clone() {
        return new SorterTagFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.SORTER_TAG_FILTER;
    }

    @Override
    public void setTagName(String name) {
        this.tagName = name;
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }
}

